/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import java.awt.Color;
import java.util.Random;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRFoods;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.LOTRPotions;
import lotr.common.entity.ai.LOTREntityAIAttackOnCollide;
import lotr.common.entity.npc.LOTREntityHobbit;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTRTradeEntries;
import lotr.common.entity.npc.LOTRTravellingTrader;
import lotr.common.item.LOTRItemLeatherHat;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class LOTREntityHobbitBartender2
extends LOTREntityHobbit
implements LOTRTravellingTrader {
    public LOTREntityHobbitBartender2(World world) {
        super(world);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new LOTREntityAIAttackOnCollide(this, 1.3, true));
    }

    @Override
    public void setupNPCGender() {
        this.familyInfo.setMale(true);
    }

    public int func_70658_aO() {
        return 5;
    }

    @Override
    public LOTREntityNPC createTravellingEscort() {
        return null;
    }

    @Override
    public LOTRTradeEntries getBuyPool() {
        return LOTRTradeEntries.HOBBIT_TRADER_BUY;
    }

    @Override
    public LOTRTradeEntries getSellPool() {
        return LOTRTradeEntries.HOBBIT_TRADER_SELL;
    }

    @Override
    public void func_70645_a(DamageSource source) {
        super.func_70645_a(source);
        if (source.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)source.func_76346_g();
            player.func_70690_d(new PotionEffect(LOTRPotions.curse.field_76415_H, 24000, 0));
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        this.npcItemsInv.setMeleeWeapon(new ItemStack(LOTRMod.daggerIron));
        this.npcItemsInv.setIdleItem(null);
        ItemStack hat = new ItemStack(LOTRMod.leatherHat);
        float h = 0.06111111f;
        float s = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)0.5f);
        float b = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)0.5f);
        int hatColor = Color.HSBtoRGB(h, s, b) & 0xFFFFFF;
        LOTRItemLeatherHat.setHatColor(hat, hatColor);
        if (this.field_70146_Z.nextInt(3) == 0) {
            h = this.field_70146_Z.nextFloat();
            s = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.7f, (float)0.9f);
            b = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.8f, (float)1.0f);
        } else {
            h = 0.0f;
            s = 0.0f;
            b = this.field_70146_Z.nextFloat();
        }
        int featherColor = Color.HSBtoRGB(h, s, b) & 0xFFFFFF;
        LOTRItemLeatherHat.setFeatherColor(hat, featherColor);
        this.func_70062_b(4, hat);
        return data;
    }

    @Override
    protected void dropHobbitItems(boolean flag, int i) {
        int count = this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(i + 1);
        block9: for (int k = 0; k < count; ++k) {
            int j = this.field_70146_Z.nextInt(10);
            switch (j) {
                case 0: 
                case 1: {
                    this.func_70099_a(LOTRFoods.HOBBIT.getRandomFood(this.field_70146_Z), 0.0f);
                    continue block9;
                }
                case 2: {
                    this.func_70099_a(new ItemStack(Items.field_151074_bl, 2 + this.field_70146_Z.nextInt(3)), 0.0f);
                    continue block9;
                }
                case 3: {
                    this.func_70099_a(new ItemStack(Items.field_151054_z, 1 + this.field_70146_Z.nextInt(4)), 0.0f);
                    continue block9;
                }
                case 4: {
                    this.func_70099_a(new ItemStack(LOTRMod.hobbitPipe, 1, this.field_70146_Z.nextInt(100)), 0.0f);
                    continue block9;
                }
                case 5: {
                    this.func_70099_a(new ItemStack(LOTRMod.pipeweed, 1 + this.field_70146_Z.nextInt(2)), 0.0f);
                    continue block9;
                }
                case 6: 
                case 7: 
                case 8: {
                    this.func_70099_a(new ItemStack(LOTRMod.mug), 0.0f);
                    continue block9;
                }
                case 9: {
                    Item drink = LOTRFoods.HOBBIT_DRINK.getRandomFood(this.field_70146_Z).func_77973_b();
                    this.func_70099_a(new ItemStack(drink, 1, 1 + this.field_70146_Z.nextInt(3)), 0.0f);
                }
            }
        }
    }

    @Override
    public float getAlignmentBonus() {
        return 2.0f;
    }

    @Override
    public boolean canTradeWith(EntityPlayer entityplayer) {
        return this.isFriendly(entityplayer);
    }

    @Override
    public void onPlayerTrade(EntityPlayer entityplayer, LOTRTradeEntries.TradeType type, ItemStack itemstack) {
        LOTRLevelData.getData(entityplayer).addAchievement(LOTRAchievement.tradeBartender);
        if (type == LOTRTradeEntries.TradeType.SELL && itemstack.func_77973_b() == LOTRMod.pipeweedLeaf) {
            LOTRLevelData.getData(entityplayer).addAchievement(LOTRAchievement.sellPipeweedLeaf);
        }
    }

    @Override
    public boolean shouldTraderRespawn() {
        return false;
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isFriendlyAndAligned(entityplayer)) {
            return "misc/hobbitTrader/friendly";
        }
        return "misc/hobbitTrader/hostile";
    }

    @Override
    public String getDepartureSpeech() {
        return "misc/hobbitTrader/departure";
    }
}

